#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Iterable

from init_helpers import raise_if

from .requirement import SecurityRequirement
from .scheme import SecurityScheme


def get_securities_arg_names(securities: Iterable[SecurityRequirement | SecurityScheme]) -> frozenset[str]:
    result = None
    for security in securities:
        names = set(security.argument_name_to_getter.keys()) if isinstance(security, SecurityRequirement) else set()
        if result is None:
            result = names
        else:
            raise_if(names != result, ValueError(f'All {securities=} must provide same arguments: {names} != {result}'))
    return frozenset(result or tuple())
