#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import http_tools
from init_helpers import try_extract_type_notes
from more_itertools import first

import openapi_tools.spec


def get_response_from_answer(answer: type[http_tools.Answer]) -> openapi_tools.spec.Response:
    answer, notes = try_extract_type_notes(answer)
    answer_examples = [note for note in notes if isinstance(note, openapi_tools.spec.AnswerExample)]
    content_type_to_media_type = {}
    if content_type := answer.get_class_content_type():
        content_type_to_media_type = {
            content_type: openapi_tools.spec.MediaType(answer.get_class_payload_type(), answer_examples)}
    return openapi_tools.spec.Response(
        description=first((note for note in notes if isinstance(note, str)), default=''),
        content_type_to_media_type=content_type_to_media_type, key=answer.__name__
    )
