#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any

from frozendict import frozendict
from http_tools import IncomingRequest
from init_helpers.dict_to_dataclass import convert_to_type

from .call_parameter import CallParameter
from .spec_parameter import SpecParameter


@dataclass(frozen=True, slots=True, kw_only=True)
class SecurityParameter(CallParameter):
    """Parameter using value from Security"""
    name: str

    async def get(self, incoming_request: IncomingRequest, security_kwargs: dict[str, Any]) -> Any:
        value = security_kwargs[self.name]
        return convert_to_type(self.schema, self.name, value)

    def get_spec_parameters(self) -> frozendict[SpecParameter, None]:
        return frozendict()
