#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from init_helpers import ReprInDumps


@dataclass(frozen=True, slots=True)
class SpecRef(ReprInDumps):
    ref: str
    summary: str = ''
    description: str = ''

    def __repr_in_dumps__(self) -> dict[str, str]:
        result = {'$ref': self.ref}
        result |= {'summary': self.summary} if self.summary else {}
        result |= {'description': self.description} if self.description else {}
        return result

    def __repr__(self) -> str:
        return f'SpecRef({", ".join({f"{key}={value!r}" for key, value in self.__repr_in_dumps__().items()})})'

    __str__ = __repr__
