#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass


@dataclass(frozen=True)
class OverexposeAnalyzeResult:
    stream_url: str
    snapshot_done_at: float
    analyzed_at: float
    certainty: float
    snapshot_file_id: str
    pixel_brightness_threshold: int
    threshold_overexposed_percentage: float
    box_min_area: int
    countable_image_overexposed_percentage: float
    reference_image_file_ids: list[str]
