#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass


@dataclass(frozen=True)
class OverexposeAnalyzeResult:
    rtsp_url: str
    snapshot_file_id: str
    snapshot_done_at: float
    reference_image_file_ids: list[str]
    detector_requests: list[dict[str, int | float]]
    detector_results: list[dict[str, list[dict[str, int | float]]]]
    comparison_settings: dict[str, list[dict[str, int | float]]]
    comparison_results: list[int]
    result: int
    analyzed_at: float
