#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Marokin <m.marokin@abm-jsc.ru>


from dataclasses import dataclass, field
from detector_connector import DetectorSettings


@dataclass(frozen=True)
class ImageBox:
    left_up_x_percentage: float
    left_up_y_percentage: float
    right_bottom_x_percentage: float
    right_bottom_y_percentage: float
    created_at: float | None = None


@dataclass(frozen=True)
class OverexposeSettings(DetectorSettings):
    pixel_brightness_threshold: int
    box_min_area: int
    overexposed_percentage_threshold: float
    locked: float | None = None
    image_boxes: list[ImageBox] = field(default_factory=list)
