from typing import Final

from http_tools import CONTEXT_VAR_REQUEST_ID


EXEMPLAR_LENGTH_LIMIT: Final[int] = 128


def get_request_id_exemplar() -> dict[str, str] | None:
    if request_id := CONTEXT_VAR_REQUEST_ID.get():
        if len(request_id) > EXEMPLAR_LENGTH_LIMIT - len("request_id"):
            request_id = request_id[:EXEMPLAR_LENGTH_LIMIT - len("request_id")]
        return {"request_id": request_id}
