# public-api-server-connector
Mentortools public API service

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.2.1+1972177117
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import public_api_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import public_api_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import public_api_server_connector
from public_api_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = public_api_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = public_api_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with public_api_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = public_api_server_connector.ApiKeyAuthApi(api_client)
    course_create = public_api_server_connector.CourseCreate() # CourseCreate | 

    try:
        # Add Course
        api_response = await api_instance.add_course_courses_v1_post(course_create)
        print("The response of ApiKeyAuthApi->add_course_courses_v1_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApiKeyAuthApi->add_course_courses_v1_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeyAuthApi* | [**add_course_courses_v1_post**](docs/ApiKeyAuthApi.md#add_course_courses_v1_post) | **POST** /courses/v1/ | Add Course
*ApiKeyAuthApi* | [**add_course_module_courses_v1_course_id_modules_post**](docs/ApiKeyAuthApi.md#add_course_module_courses_v1_course_id_modules_post) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*ApiKeyAuthApi* | [**add_course_module_lessons_courses_v1_modules_module_id_lessons_post**](docs/ApiKeyAuthApi.md#add_course_module_lessons_courses_v1_modules_module_id_lessons_post) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*ApiKeyAuthApi* | [**add_module_submodule_courses_v1_modules_module_id_submodules_post**](docs/ApiKeyAuthApi.md#add_module_submodule_courses_v1_modules_module_id_submodules_post) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*ApiKeyAuthApi* | [**count_courses_courses_v1_count_get**](docs/ApiKeyAuthApi.md#count_courses_courses_v1_count_get) | **GET** /courses/v1/count | Count Courses
*ApiKeyAuthApi* | [**delete_course_courses_v1_course_id_delete**](docs/ApiKeyAuthApi.md#delete_course_courses_v1_course_id_delete) | **DELETE** /courses/v1/{course_id} | Delete Course
*ApiKeyAuthApi* | [**delete_course_module_courses_v1_modules_module_id_delete**](docs/ApiKeyAuthApi.md#delete_course_module_courses_v1_modules_module_id_delete) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*ApiKeyAuthApi* | [**delete_course_module_lesson_courses_v1_lessons_lesson_id_delete**](docs/ApiKeyAuthApi.md#delete_course_module_lesson_courses_v1_lessons_lesson_id_delete) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*ApiKeyAuthApi* | [**delete_module_submodule_courses_v1_submodules_submodule_id_delete**](docs/ApiKeyAuthApi.md#delete_module_submodule_courses_v1_submodules_submodule_id_delete) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*ApiKeyAuthApi* | [**get_course_courses_v1_course_id_get**](docs/ApiKeyAuthApi.md#get_course_courses_v1_course_id_get) | **GET** /courses/v1/{course_id} | Get Course
*ApiKeyAuthApi* | [**get_course_info_courses_v1_course_id_info_get**](docs/ApiKeyAuthApi.md#get_course_info_courses_v1_course_id_info_get) | **GET** /courses/v1/{course_id}/info | Get Course Info
*ApiKeyAuthApi* | [**get_course_module_count_courses_v1_course_id_modules_count_get**](docs/ApiKeyAuthApi.md#get_course_module_count_courses_v1_course_id_modules_count_get) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*ApiKeyAuthApi* | [**get_course_module_courses_v1_modules_module_id_get**](docs/ApiKeyAuthApi.md#get_course_module_courses_v1_modules_module_id_get) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*ApiKeyAuthApi* | [**get_course_module_info_courses_v1_modules_module_id_info_get**](docs/ApiKeyAuthApi.md#get_course_module_info_courses_v1_modules_module_id_info_get) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*ApiKeyAuthApi* | [**get_course_module_lesson_courses_v1_lessons_lesson_id_get**](docs/ApiKeyAuthApi.md#get_course_module_lesson_courses_v1_lessons_lesson_id_get) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*ApiKeyAuthApi* | [**get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get**](docs/ApiKeyAuthApi.md#get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*ApiKeyAuthApi* | [**get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get**](docs/ApiKeyAuthApi.md#get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*ApiKeyAuthApi* | [**get_course_module_lessons_courses_v1_modules_module_id_lessons_get**](docs/ApiKeyAuthApi.md#get_course_module_lessons_courses_v1_modules_module_id_lessons_get) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*ApiKeyAuthApi* | [**get_course_modules_courses_v1_course_id_modules_get**](docs/ApiKeyAuthApi.md#get_course_modules_courses_v1_course_id_modules_get) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*ApiKeyAuthApi* | [**get_courses_courses_v1_get**](docs/ApiKeyAuthApi.md#get_courses_courses_v1_get) | **GET** /courses/v1/ | Get Courses
*ApiKeyAuthApi* | [**get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get**](docs/ApiKeyAuthApi.md#get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*ApiKeyAuthApi* | [**get_module_submodules_courses_v1_modules_module_id_submodules_get**](docs/ApiKeyAuthApi.md#get_module_submodules_courses_v1_modules_module_id_submodules_get) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*ApiKeyAuthApi* | [**get_submodule_courses_v1_submodules_submodule_id_get**](docs/ApiKeyAuthApi.md#get_submodule_courses_v1_submodules_submodule_id_get) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*ApiKeyAuthApi* | [**handle_ipn_ipn_v1_handle_post**](docs/ApiKeyAuthApi.md#handle_ipn_ipn_v1_handle_post) | **POST** /ipn/v1/handle | Handle Ipn
*ApiKeyAuthApi* | [**patch_course_courses_v1_course_id_patch**](docs/ApiKeyAuthApi.md#patch_course_courses_v1_course_id_patch) | **PATCH** /courses/v1/{course_id} | Patch Course
*ApiKeyAuthApi* | [**patch_course_module_courses_v1_modules_module_id_patch**](docs/ApiKeyAuthApi.md#patch_course_module_courses_v1_modules_module_id_patch) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*ApiKeyAuthApi* | [**patch_course_module_lesson_courses_v1_lessons_lesson_id_patch**](docs/ApiKeyAuthApi.md#patch_course_module_lesson_courses_v1_lessons_lesson_id_patch) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*ApiKeyAuthApi* | [**patch_module_submodule_courses_v1_submodules_submodule_id_patch**](docs/ApiKeyAuthApi.md#patch_module_submodule_courses_v1_submodules_submodule_id_patch) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*ApiKeyAuthApi* | [**update_course_courses_v1_course_id_put**](docs/ApiKeyAuthApi.md#update_course_courses_v1_course_id_put) | **PUT** /courses/v1/{course_id} | Update Course
*ApiKeyAuthApi* | [**update_course_module_courses_v1_modules_module_id_put**](docs/ApiKeyAuthApi.md#update_course_module_courses_v1_modules_module_id_put) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*ApiKeyAuthApi* | [**update_course_module_lesson_courses_v1_lessons_lesson_id_put**](docs/ApiKeyAuthApi.md#update_course_module_lesson_courses_v1_lessons_lesson_id_put) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*ApiKeyAuthApi* | [**update_module_submodule_courses_v1_submodules_submodule_id_put**](docs/ApiKeyAuthApi.md#update_module_submodule_courses_v1_submodules_submodule_id_put) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule
*ApiKeysApi* | [**count_keys_api_keys_v1_count_get**](docs/ApiKeysApi.md#count_keys_api_keys_v1_count_get) | **GET** /api_keys/v1/count | Count Keys
*ApiKeysApi* | [**count_permission_categories_api_keys_v1_permision_categories_count_get**](docs/ApiKeysApi.md#count_permission_categories_api_keys_v1_permision_categories_count_get) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*ApiKeysApi* | [**create_key_api_keys_v1_post**](docs/ApiKeysApi.md#create_key_api_keys_v1_post) | **POST** /api_keys/v1/ | Create Key
*ApiKeysApi* | [**delete_key_api_keys_v1_key_id_delete**](docs/ApiKeysApi.md#delete_key_api_keys_v1_key_id_delete) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*ApiKeysApi* | [**get_key_api_keys_v1_key_id_get**](docs/ApiKeysApi.md#get_key_api_keys_v1_key_id_get) | **GET** /api_keys/v1/{key_id} | Get Key
*ApiKeysApi* | [**get_keys_api_keys_v1_get**](docs/ApiKeysApi.md#get_keys_api_keys_v1_get) | **GET** /api_keys/v1/ | Get Keys
*ApiKeysApi* | [**get_permission_categories_api_keys_v1_permision_categories_get**](docs/ApiKeysApi.md#get_permission_categories_api_keys_v1_permision_categories_get) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*ApiKeysApi* | [**patch_key_api_keys_v1_key_id_patch**](docs/ApiKeysApi.md#patch_key_api_keys_v1_key_id_patch) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*ApiKeysApi* | [**update_key_api_keys_v1_key_id_put**](docs/ApiKeysApi.md#update_key_api_keys_v1_key_id_put) | **PUT** /api_keys/v1/{key_id} | Update Key
*ApiLogsApi* | [**count_logs_api_logs_v1_count_get**](docs/ApiLogsApi.md#count_logs_api_logs_v1_count_get) | **GET** /api_logs/v1/count | Count Logs
*ApiLogsApi* | [**get_log_api_logs_v1_log_id_get**](docs/ApiLogsApi.md#get_log_api_logs_v1_log_id_get) | **GET** /api_logs/v1/{log_id} | Get Log
*ApiLogsApi* | [**get_logs_api_logs_v1_get**](docs/ApiLogsApi.md#get_logs_api_logs_v1_get) | **GET** /api_logs/v1/ | Get Logs
*ApiSpecApi* | [**count_spec_methods_specification_methods_count_get**](docs/ApiSpecApi.md#count_spec_methods_specification_methods_count_get) | **GET** /specification/methods/count | Count Spec Methods
*ApiSpecApi* | [**get_spec_methods_specification_methods_get**](docs/ApiSpecApi.md#get_spec_methods_specification_methods_get) | **GET** /specification/methods | Get Spec Methods
*ApiSpecApi* | [**get_spec_specification_get**](docs/ApiSpecApi.md#get_spec_specification_get) | **GET** /specification/ | Get Spec
*ApiSpecApi* | [**get_spec_ui_specification_ui_get**](docs/ApiSpecApi.md#get_spec_ui_specification_ui_get) | **GET** /specification/ui | Get Spec Ui
*CoursesApi* | [**add_course_courses_v1_post**](docs/CoursesApi.md#add_course_courses_v1_post) | **POST** /courses/v1/ | Add Course
*CoursesApi* | [**add_course_module_courses_v1_course_id_modules_post**](docs/CoursesApi.md#add_course_module_courses_v1_course_id_modules_post) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*CoursesApi* | [**add_course_module_lessons_courses_v1_modules_module_id_lessons_post**](docs/CoursesApi.md#add_course_module_lessons_courses_v1_modules_module_id_lessons_post) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*CoursesApi* | [**add_module_submodule_courses_v1_modules_module_id_submodules_post**](docs/CoursesApi.md#add_module_submodule_courses_v1_modules_module_id_submodules_post) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*CoursesApi* | [**count_courses_courses_v1_count_get**](docs/CoursesApi.md#count_courses_courses_v1_count_get) | **GET** /courses/v1/count | Count Courses
*CoursesApi* | [**delete_course_courses_v1_course_id_delete**](docs/CoursesApi.md#delete_course_courses_v1_course_id_delete) | **DELETE** /courses/v1/{course_id} | Delete Course
*CoursesApi* | [**delete_course_module_courses_v1_modules_module_id_delete**](docs/CoursesApi.md#delete_course_module_courses_v1_modules_module_id_delete) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*CoursesApi* | [**delete_course_module_lesson_courses_v1_lessons_lesson_id_delete**](docs/CoursesApi.md#delete_course_module_lesson_courses_v1_lessons_lesson_id_delete) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*CoursesApi* | [**delete_module_submodule_courses_v1_submodules_submodule_id_delete**](docs/CoursesApi.md#delete_module_submodule_courses_v1_submodules_submodule_id_delete) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*CoursesApi* | [**get_course_courses_v1_course_id_get**](docs/CoursesApi.md#get_course_courses_v1_course_id_get) | **GET** /courses/v1/{course_id} | Get Course
*CoursesApi* | [**get_course_info_courses_v1_course_id_info_get**](docs/CoursesApi.md#get_course_info_courses_v1_course_id_info_get) | **GET** /courses/v1/{course_id}/info | Get Course Info
*CoursesApi* | [**get_course_module_count_courses_v1_course_id_modules_count_get**](docs/CoursesApi.md#get_course_module_count_courses_v1_course_id_modules_count_get) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*CoursesApi* | [**get_course_module_courses_v1_modules_module_id_get**](docs/CoursesApi.md#get_course_module_courses_v1_modules_module_id_get) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*CoursesApi* | [**get_course_module_info_courses_v1_modules_module_id_info_get**](docs/CoursesApi.md#get_course_module_info_courses_v1_modules_module_id_info_get) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*CoursesApi* | [**get_course_module_lesson_courses_v1_lessons_lesson_id_get**](docs/CoursesApi.md#get_course_module_lesson_courses_v1_lessons_lesson_id_get) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*CoursesApi* | [**get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get**](docs/CoursesApi.md#get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*CoursesApi* | [**get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get**](docs/CoursesApi.md#get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*CoursesApi* | [**get_course_module_lessons_courses_v1_modules_module_id_lessons_get**](docs/CoursesApi.md#get_course_module_lessons_courses_v1_modules_module_id_lessons_get) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*CoursesApi* | [**get_course_modules_courses_v1_course_id_modules_get**](docs/CoursesApi.md#get_course_modules_courses_v1_course_id_modules_get) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*CoursesApi* | [**get_courses_courses_v1_get**](docs/CoursesApi.md#get_courses_courses_v1_get) | **GET** /courses/v1/ | Get Courses
*CoursesApi* | [**get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get**](docs/CoursesApi.md#get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*CoursesApi* | [**get_module_submodules_courses_v1_modules_module_id_submodules_get**](docs/CoursesApi.md#get_module_submodules_courses_v1_modules_module_id_submodules_get) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*CoursesApi* | [**get_submodule_courses_v1_submodules_submodule_id_get**](docs/CoursesApi.md#get_submodule_courses_v1_submodules_submodule_id_get) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*CoursesApi* | [**patch_course_courses_v1_course_id_patch**](docs/CoursesApi.md#patch_course_courses_v1_course_id_patch) | **PATCH** /courses/v1/{course_id} | Patch Course
*CoursesApi* | [**patch_course_module_courses_v1_modules_module_id_patch**](docs/CoursesApi.md#patch_course_module_courses_v1_modules_module_id_patch) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*CoursesApi* | [**patch_course_module_lesson_courses_v1_lessons_lesson_id_patch**](docs/CoursesApi.md#patch_course_module_lesson_courses_v1_lessons_lesson_id_patch) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*CoursesApi* | [**patch_module_submodule_courses_v1_submodules_submodule_id_patch**](docs/CoursesApi.md#patch_module_submodule_courses_v1_submodules_submodule_id_patch) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*CoursesApi* | [**update_course_courses_v1_course_id_put**](docs/CoursesApi.md#update_course_courses_v1_course_id_put) | **PUT** /courses/v1/{course_id} | Update Course
*CoursesApi* | [**update_course_module_courses_v1_modules_module_id_put**](docs/CoursesApi.md#update_course_module_courses_v1_modules_module_id_put) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*CoursesApi* | [**update_course_module_lesson_courses_v1_lessons_lesson_id_put**](docs/CoursesApi.md#update_course_module_lesson_courses_v1_lessons_lesson_id_put) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*CoursesApi* | [**update_module_submodule_courses_v1_submodules_submodule_id_put**](docs/CoursesApi.md#update_module_submodule_courses_v1_submodules_submodule_id_put) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule
*HealthApi* | [**health_check_get**](docs/HealthApi.md#health_check_get) | **GET** / | Health Check
*IpnApi* | [**handle_ipn_ipn_v1_handle_post**](docs/IpnApi.md#handle_ipn_ipn_v1_handle_post) | **POST** /ipn/v1/handle | Handle Ipn
*JwtTokenAuthApi* | [**count_keys_api_keys_v1_count_get**](docs/JwtTokenAuthApi.md#count_keys_api_keys_v1_count_get) | **GET** /api_keys/v1/count | Count Keys
*JwtTokenAuthApi* | [**count_logs_api_logs_v1_count_get**](docs/JwtTokenAuthApi.md#count_logs_api_logs_v1_count_get) | **GET** /api_logs/v1/count | Count Logs
*JwtTokenAuthApi* | [**count_permission_categories_api_keys_v1_permision_categories_count_get**](docs/JwtTokenAuthApi.md#count_permission_categories_api_keys_v1_permision_categories_count_get) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*JwtTokenAuthApi* | [**create_key_api_keys_v1_post**](docs/JwtTokenAuthApi.md#create_key_api_keys_v1_post) | **POST** /api_keys/v1/ | Create Key
*JwtTokenAuthApi* | [**delete_key_api_keys_v1_key_id_delete**](docs/JwtTokenAuthApi.md#delete_key_api_keys_v1_key_id_delete) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*JwtTokenAuthApi* | [**get_key_api_keys_v1_key_id_get**](docs/JwtTokenAuthApi.md#get_key_api_keys_v1_key_id_get) | **GET** /api_keys/v1/{key_id} | Get Key
*JwtTokenAuthApi* | [**get_keys_api_keys_v1_get**](docs/JwtTokenAuthApi.md#get_keys_api_keys_v1_get) | **GET** /api_keys/v1/ | Get Keys
*JwtTokenAuthApi* | [**get_log_api_logs_v1_log_id_get**](docs/JwtTokenAuthApi.md#get_log_api_logs_v1_log_id_get) | **GET** /api_logs/v1/{log_id} | Get Log
*JwtTokenAuthApi* | [**get_logs_api_logs_v1_get**](docs/JwtTokenAuthApi.md#get_logs_api_logs_v1_get) | **GET** /api_logs/v1/ | Get Logs
*JwtTokenAuthApi* | [**get_permission_categories_api_keys_v1_permision_categories_get**](docs/JwtTokenAuthApi.md#get_permission_categories_api_keys_v1_permision_categories_get) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*JwtTokenAuthApi* | [**patch_key_api_keys_v1_key_id_patch**](docs/JwtTokenAuthApi.md#patch_key_api_keys_v1_key_id_patch) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*JwtTokenAuthApi* | [**update_key_api_keys_v1_key_id_put**](docs/JwtTokenAuthApi.md#update_key_api_keys_v1_key_id_put) | **PUT** /api_keys/v1/{key_id} | Update Key
*SpecificationApi* | [**count_spec_methods_specification_methods_count_get**](docs/SpecificationApi.md#count_spec_methods_specification_methods_count_get) | **GET** /specification/methods/count | Count Spec Methods
*SpecificationApi* | [**get_spec_methods_specification_methods_get**](docs/SpecificationApi.md#get_spec_methods_specification_methods_get) | **GET** /specification/methods | Get Spec Methods
*SpecificationApi* | [**get_spec_specification_get**](docs/SpecificationApi.md#get_spec_specification_get) | **GET** /specification/ | Get Spec
*SpecificationApi* | [**get_spec_ui_specification_ui_get**](docs/SpecificationApi.md#get_spec_ui_specification_ui_get) | **GET** /specification/ui | Get Spec Ui
*V1Api* | [**add_course_courses_v1_post**](docs/V1Api.md#add_course_courses_v1_post) | **POST** /courses/v1/ | Add Course
*V1Api* | [**add_course_module_courses_v1_course_id_modules_post**](docs/V1Api.md#add_course_module_courses_v1_course_id_modules_post) | **POST** /courses/v1/{course_id}/modules | Add Course Module
*V1Api* | [**add_course_module_lessons_courses_v1_modules_module_id_lessons_post**](docs/V1Api.md#add_course_module_lessons_courses_v1_modules_module_id_lessons_post) | **POST** /courses/v1/modules/{module_id}/lessons | Add Course Module Lessons
*V1Api* | [**add_module_submodule_courses_v1_modules_module_id_submodules_post**](docs/V1Api.md#add_module_submodule_courses_v1_modules_module_id_submodules_post) | **POST** /courses/v1/modules/{module_id}/submodules | Add Module Submodule
*V1Api* | [**count_courses_courses_v1_count_get**](docs/V1Api.md#count_courses_courses_v1_count_get) | **GET** /courses/v1/count | Count Courses
*V1Api* | [**count_keys_api_keys_v1_count_get**](docs/V1Api.md#count_keys_api_keys_v1_count_get) | **GET** /api_keys/v1/count | Count Keys
*V1Api* | [**count_logs_api_logs_v1_count_get**](docs/V1Api.md#count_logs_api_logs_v1_count_get) | **GET** /api_logs/v1/count | Count Logs
*V1Api* | [**count_permission_categories_api_keys_v1_permision_categories_count_get**](docs/V1Api.md#count_permission_categories_api_keys_v1_permision_categories_count_get) | **GET** /api_keys/v1/permision_categories/count | Count Permission Categories
*V1Api* | [**create_key_api_keys_v1_post**](docs/V1Api.md#create_key_api_keys_v1_post) | **POST** /api_keys/v1/ | Create Key
*V1Api* | [**delete_course_courses_v1_course_id_delete**](docs/V1Api.md#delete_course_courses_v1_course_id_delete) | **DELETE** /courses/v1/{course_id} | Delete Course
*V1Api* | [**delete_course_module_courses_v1_modules_module_id_delete**](docs/V1Api.md#delete_course_module_courses_v1_modules_module_id_delete) | **DELETE** /courses/v1/modules/{module_id} | Delete Course Module
*V1Api* | [**delete_course_module_lesson_courses_v1_lessons_lesson_id_delete**](docs/V1Api.md#delete_course_module_lesson_courses_v1_lessons_lesson_id_delete) | **DELETE** /courses/v1/lessons/{lesson_id} | Delete Course Module Lesson
*V1Api* | [**delete_key_api_keys_v1_key_id_delete**](docs/V1Api.md#delete_key_api_keys_v1_key_id_delete) | **DELETE** /api_keys/v1/{key_id} | Delete Key
*V1Api* | [**delete_module_submodule_courses_v1_submodules_submodule_id_delete**](docs/V1Api.md#delete_module_submodule_courses_v1_submodules_submodule_id_delete) | **DELETE** /courses/v1/submodules/{submodule_id} | Delete Module Submodule
*V1Api* | [**get_course_courses_v1_course_id_get**](docs/V1Api.md#get_course_courses_v1_course_id_get) | **GET** /courses/v1/{course_id} | Get Course
*V1Api* | [**get_course_info_courses_v1_course_id_info_get**](docs/V1Api.md#get_course_info_courses_v1_course_id_info_get) | **GET** /courses/v1/{course_id}/info | Get Course Info
*V1Api* | [**get_course_module_count_courses_v1_course_id_modules_count_get**](docs/V1Api.md#get_course_module_count_courses_v1_course_id_modules_count_get) | **GET** /courses/v1/{course_id}/modules/count | Get Course Module Count
*V1Api* | [**get_course_module_courses_v1_modules_module_id_get**](docs/V1Api.md#get_course_module_courses_v1_modules_module_id_get) | **GET** /courses/v1/modules/{module_id} | Get Course Module
*V1Api* | [**get_course_module_info_courses_v1_modules_module_id_info_get**](docs/V1Api.md#get_course_module_info_courses_v1_modules_module_id_info_get) | **GET** /courses/v1/modules/{module_id}/info | Get Course Module Info
*V1Api* | [**get_course_module_lesson_courses_v1_lessons_lesson_id_get**](docs/V1Api.md#get_course_module_lesson_courses_v1_lessons_lesson_id_get) | **GET** /courses/v1/lessons/{lesson_id} | Get Course Module Lesson
*V1Api* | [**get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get**](docs/V1Api.md#get_course_module_lesson_info_courses_v1_lessons_lesson_id_info_get) | **GET** /courses/v1/lessons/{lesson_id}/info | Get Course Module Lesson Info
*V1Api* | [**get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get**](docs/V1Api.md#get_course_module_lessons_count_courses_v1_modules_module_id_lessons_count_get) | **GET** /courses/v1/modules/{module_id}/lessons/count | Get Course Module Lessons Count
*V1Api* | [**get_course_module_lessons_courses_v1_modules_module_id_lessons_get**](docs/V1Api.md#get_course_module_lessons_courses_v1_modules_module_id_lessons_get) | **GET** /courses/v1/modules/{module_id}/lessons | Get Course Module Lessons
*V1Api* | [**get_course_modules_courses_v1_course_id_modules_get**](docs/V1Api.md#get_course_modules_courses_v1_course_id_modules_get) | **GET** /courses/v1/{course_id}/modules | Get Course Modules
*V1Api* | [**get_courses_courses_v1_get**](docs/V1Api.md#get_courses_courses_v1_get) | **GET** /courses/v1/ | Get Courses
*V1Api* | [**get_key_api_keys_v1_key_id_get**](docs/V1Api.md#get_key_api_keys_v1_key_id_get) | **GET** /api_keys/v1/{key_id} | Get Key
*V1Api* | [**get_keys_api_keys_v1_get**](docs/V1Api.md#get_keys_api_keys_v1_get) | **GET** /api_keys/v1/ | Get Keys
*V1Api* | [**get_log_api_logs_v1_log_id_get**](docs/V1Api.md#get_log_api_logs_v1_log_id_get) | **GET** /api_logs/v1/{log_id} | Get Log
*V1Api* | [**get_logs_api_logs_v1_get**](docs/V1Api.md#get_logs_api_logs_v1_get) | **GET** /api_logs/v1/ | Get Logs
*V1Api* | [**get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get**](docs/V1Api.md#get_module_submodule_count_courses_v1_modules_module_id_submodules_count_get) | **GET** /courses/v1/modules/{module_id}/submodules/count | Get Module Submodule Count
*V1Api* | [**get_module_submodules_courses_v1_modules_module_id_submodules_get**](docs/V1Api.md#get_module_submodules_courses_v1_modules_module_id_submodules_get) | **GET** /courses/v1/modules/{module_id}/submodules | Get Module Submodules
*V1Api* | [**get_permission_categories_api_keys_v1_permision_categories_get**](docs/V1Api.md#get_permission_categories_api_keys_v1_permision_categories_get) | **GET** /api_keys/v1/permision_categories | Get Permission Categories
*V1Api* | [**get_submodule_courses_v1_submodules_submodule_id_get**](docs/V1Api.md#get_submodule_courses_v1_submodules_submodule_id_get) | **GET** /courses/v1/submodules/{submodule_id} | Get Submodule
*V1Api* | [**handle_ipn_ipn_v1_handle_post**](docs/V1Api.md#handle_ipn_ipn_v1_handle_post) | **POST** /ipn/v1/handle | Handle Ipn
*V1Api* | [**patch_course_courses_v1_course_id_patch**](docs/V1Api.md#patch_course_courses_v1_course_id_patch) | **PATCH** /courses/v1/{course_id} | Patch Course
*V1Api* | [**patch_course_module_courses_v1_modules_module_id_patch**](docs/V1Api.md#patch_course_module_courses_v1_modules_module_id_patch) | **PATCH** /courses/v1/modules/{module_id} | Patch Course Module
*V1Api* | [**patch_course_module_lesson_courses_v1_lessons_lesson_id_patch**](docs/V1Api.md#patch_course_module_lesson_courses_v1_lessons_lesson_id_patch) | **PATCH** /courses/v1/lessons/{lesson_id} | Patch Course Module Lesson
*V1Api* | [**patch_key_api_keys_v1_key_id_patch**](docs/V1Api.md#patch_key_api_keys_v1_key_id_patch) | **PATCH** /api_keys/v1/{key_id} | Patch Key
*V1Api* | [**patch_module_submodule_courses_v1_submodules_submodule_id_patch**](docs/V1Api.md#patch_module_submodule_courses_v1_submodules_submodule_id_patch) | **PATCH** /courses/v1/submodules/{submodule_id} | Patch Module Submodule
*V1Api* | [**update_course_courses_v1_course_id_put**](docs/V1Api.md#update_course_courses_v1_course_id_put) | **PUT** /courses/v1/{course_id} | Update Course
*V1Api* | [**update_course_module_courses_v1_modules_module_id_put**](docs/V1Api.md#update_course_module_courses_v1_modules_module_id_put) | **PUT** /courses/v1/modules/{module_id} | Update Course Module
*V1Api* | [**update_course_module_lesson_courses_v1_lessons_lesson_id_put**](docs/V1Api.md#update_course_module_lesson_courses_v1_lessons_lesson_id_put) | **PUT** /courses/v1/lessons/{lesson_id} | Update Course Module Lesson
*V1Api* | [**update_key_api_keys_v1_key_id_put**](docs/V1Api.md#update_key_api_keys_v1_key_id_put) | **PUT** /api_keys/v1/{key_id} | Update Key
*V1Api* | [**update_module_submodule_courses_v1_submodules_submodule_id_put**](docs/V1Api.md#update_module_submodule_courses_v1_submodules_submodule_id_put) | **PUT** /courses/v1/submodules/{submodule_id} | Update Module Submodule


## Documentation For Models

 - [ApiKeyCreate](docs/ApiKeyCreate.md)
 - [ApiKeyCreateResponse](docs/ApiKeyCreateResponse.md)
 - [ApiKeyGet](docs/ApiKeyGet.md)
 - [ApiKeyPatch](docs/ApiKeyPatch.md)
 - [ApiKeyUpdate](docs/ApiKeyUpdate.md)
 - [ApiLogGet](docs/ApiLogGet.md)
 - [AttachedFile](docs/AttachedFile.md)
 - [ButtonPosition](docs/ButtonPosition.md)
 - [CategoryPermissions](docs/CategoryPermissions.md)
 - [Content](docs/Content.md)
 - [ContentBlock](docs/ContentBlock.md)
 - [ContentBlockCreate](docs/ContentBlockCreate.md)
 - [ContentBlockTypeStrEnum](docs/ContentBlockTypeStrEnum.md)
 - [ContentBlockUpdate](docs/ContentBlockUpdate.md)
 - [Course](docs/Course.md)
 - [CourseAccessTypeStrEnum](docs/CourseAccessTypeStrEnum.md)
 - [CourseContentBlock](docs/CourseContentBlock.md)
 - [CourseCreate](docs/CourseCreate.md)
 - [CourseModule](docs/CourseModule.md)
 - [CourseModuleCreate](docs/CourseModuleCreate.md)
 - [CourseModulePatch](docs/CourseModulePatch.md)
 - [CourseModuleSimple](docs/CourseModuleSimple.md)
 - [CourseModuleUpdate](docs/CourseModuleUpdate.md)
 - [CourseModuleViewTypeStrEnum](docs/CourseModuleViewTypeStrEnum.md)
 - [CoursePatch](docs/CoursePatch.md)
 - [CoursePaymentTypeStrEnum](docs/CoursePaymentTypeStrEnum.md)
 - [CourseSimple](docs/CourseSimple.md)
 - [CourseSubmodule](docs/CourseSubmodule.md)
 - [CourseSubmoduleCreate](docs/CourseSubmoduleCreate.md)
 - [CourseSubmodulePatch](docs/CourseSubmodulePatch.md)
 - [CourseSubmoduleUpdate](docs/CourseSubmoduleUpdate.md)
 - [CourseToVideo](docs/CourseToVideo.md)
 - [CourseUpdate](docs/CourseUpdate.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HttpMethod](docs/HttpMethod.md)
 - [IpnPaymentRequest](docs/IpnPaymentRequest.md)
 - [LessonTypeStrEnum](docs/LessonTypeStrEnum.md)
 - [ModuleLesson](docs/ModuleLesson.md)
 - [ModuleLessonCreate](docs/ModuleLessonCreate.md)
 - [ModuleLessonPatch](docs/ModuleLessonPatch.md)
 - [ModuleLessonSimple](docs/ModuleLessonSimple.md)
 - [ModuleLessonToVideo](docs/ModuleLessonToVideo.md)
 - [ModuleLessonUpdate](docs/ModuleLessonUpdate.md)
 - [ModuleLessonUpdateContentBlocksInner](docs/ModuleLessonUpdateContentBlocksInner.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperApiKeyCreateResponse](docs/ResponseWrapperApiKeyCreateResponse.md)
 - [ResponseWrapperApiKeyGet](docs/ResponseWrapperApiKeyGet.md)
 - [ResponseWrapperApiLogGet](docs/ResponseWrapperApiLogGet.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperCourse](docs/ResponseWrapperCourse.md)
 - [ResponseWrapperCourseModule](docs/ResponseWrapperCourseModule.md)
 - [ResponseWrapperCourseModuleSimple](docs/ResponseWrapperCourseModuleSimple.md)
 - [ResponseWrapperCourseSimple](docs/ResponseWrapperCourseSimple.md)
 - [ResponseWrapperCourseSubmodule](docs/ResponseWrapperCourseSubmodule.md)
 - [ResponseWrapperInt](docs/ResponseWrapperInt.md)
 - [ResponseWrapperListApiKeyGet](docs/ResponseWrapperListApiKeyGet.md)
 - [ResponseWrapperListApiLogGet](docs/ResponseWrapperListApiLogGet.md)
 - [ResponseWrapperListCourseModuleSimple](docs/ResponseWrapperListCourseModuleSimple.md)
 - [ResponseWrapperListCourseSimple](docs/ResponseWrapperListCourseSimple.md)
 - [ResponseWrapperListCourseSubmodule](docs/ResponseWrapperListCourseSubmodule.md)
 - [ResponseWrapperListModuleLessonSimple](docs/ResponseWrapperListModuleLessonSimple.md)
 - [ResponseWrapperListStr](docs/ResponseWrapperListStr.md)
 - [ResponseWrapperModuleLesson](docs/ResponseWrapperModuleLesson.md)
 - [ResponseWrapperModuleLessonSimple](docs/ResponseWrapperModuleLessonSimple.md)
 - [Result](docs/Result.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: Origin
- **Location**: HTTP header


## Author




