# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class FileUploadResult(BaseModel):
    """
    FileUploadResult
    """
    id: StrictInt = Field(default=..., description="Mediastorage database ID, can be used to retrieve the file metadata, delete the file, etc.")
    file_id: StrictStr = Field(default=..., description="Unique file hash identifier that can be used to retrieve the file later")
    file_url: StrictStr = Field(default=..., description="Direct URL to access the file")
    embed_html: Optional[StrictStr] = Field(default=None, description="HTML snippet that can be used to embed the file in a web page. Only for images.")
    __properties = ["id", "file_id", "file_url", "embed_html"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileUploadResult:
        """Create an instance of FileUploadResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileUploadResult:
        """Create an instance of FileUploadResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileUploadResult.parse_obj(obj)

        _obj = FileUploadResult.parse_obj({
            "id": obj.get("id"),
            "file_id": obj.get("file_id"),
            "file_url": obj.get("file_url"),
            "embed_html": obj.get("embed_html")
        })
        return _obj


