# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class IpnTransaction(BaseModel):
    """
    IpnTransaction
    """
    amount: Union[StrictFloat, StrictInt] = Field(default=..., description="Amount of the transaction, as decimal number, e.g. 10.00")
    id: Optional[StrictStr] = Field(default=None, description="External id of the transaction, if provided it will be prefixed with portal id, e.g. {portal_id}-{transaction.id} and used for tracking, if not provided it will be generated by the server")
    __properties = ["amount", "id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IpnTransaction:
        """Create an instance of IpnTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IpnTransaction:
        """Create an instance of IpnTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IpnTransaction.parse_obj(obj)

        _obj = IpnTransaction.parse_obj({
            "amount": obj.get("amount"),
            "id": obj.get("id")
        })
        return _obj


