# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictBytes, StrictInt, StrictStr

from typing import Optional, Union

from public_api_server_connector.models.file_update import FileUpdate
from public_api_server_connector.models.folder_create import FolderCreate
from public_api_server_connector.models.folder_update import FolderUpdate
from public_api_server_connector.models.response_wrapper_bool import ResponseWrapperBool
from public_api_server_connector.models.response_wrapper_file import ResponseWrapperFile
from public_api_server_connector.models.response_wrapper_file_upload_result import ResponseWrapperFileUploadResult
from public_api_server_connector.models.response_wrapper_folder import ResponseWrapperFolder
from public_api_server_connector.models.response_wrapper_int import ResponseWrapperInt
from public_api_server_connector.models.response_wrapper_list_file import ResponseWrapperListFile
from public_api_server_connector.models.response_wrapper_list_folder import ResponseWrapperListFolder

from public_api_server_connector.api_client import ApiClient
from public_api_server_connector.api_response import ApiResponse
from public_api_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MediastorageApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def api_key_auth_create_folder(self, folder_create : FolderCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Create Folder  # noqa: E501

        Create folder in mediastorage  # noqa: E501

        :param folder_create: (required)
        :type folder_create: FolderCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_create_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_create_folder_with_http_info(folder_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_create_folder_with_http_info(self, folder_create : FolderCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Folder  # noqa: E501

        Create folder in mediastorage  # noqa: E501

        :param folder_create: (required)
        :type folder_create: FolderCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'folder_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_create_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['folder_create'] is not None:
            _body_params = _params['folder_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_file(self, id_ : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_file_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_file_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_folder(self, id_ : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Folder  # noqa: E501

        Delete folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_folder_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_folder_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Folder  # noqa: E501

        Delete folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_all_files_count(self, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get All Files Count  # noqa: E501

        Get file count in mediastorage, nesting is ignored  # noqa: E501

        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_all_files_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_all_files_count_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_all_files_count_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Files Count  # noqa: E501

        Get file count in mediastorage, nesting is ignored  # noqa: E501

        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_all_files_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/all/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_all_folders(self, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ResponseWrapperListFolder:  # noqa: E501
        """Get All Folders  # noqa: E501

        List folders in mediastorage, nesting is ignored  # noqa: E501

        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_all_folders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_all_folders_with_http_info(limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_all_folders_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Folders  # noqa: E501

        List folders in mediastorage, nesting is ignored  # noqa: E501

        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_all_folders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_all_folders_count(self, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get All Folders Count  # noqa: E501

        Get folder count in mediastorage, nesting is ignored  # noqa: E501

        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_all_folders_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_all_folders_count_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_all_folders_count_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Folders Count  # noqa: E501

        Get folder count in mediastorage, nesting is ignored  # noqa: E501

        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_all_folders_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/all/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_file(self, id_ : StrictInt, **kwargs) -> ResponseWrapperFile:  # noqa: E501
        """Get File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_file_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_file_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_files(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list files from")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ResponseWrapperListFile:  # noqa: E501
        """Get Files  # noqa: E501

        List files in mediastorage. Files are listed by their parent folder. If no parent folder is provided, lists root files.  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list files from
        :type parent_folder_id: int
        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_files_with_http_info(parent_folder_id, limit, offset, filename, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_files_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list files from")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Files  # noqa: E501

        List files in mediastorage. Files are listed by their parent folder. If no parent folder is provided, lists root files.  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list files from
        :type parent_folder_id: int
        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id',
            'limit',
            'offset',
            'filename'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_files" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_files_all(self, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ResponseWrapperListFile:  # noqa: E501
        """Get Files All  # noqa: E501

        List files in mediastorage. Files are listed regardless of their parent folder.  # noqa: E501

        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_files_all_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_files_all_with_http_info(limit, offset, filename, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_files_all_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Files All  # noqa: E501

        List files in mediastorage. Files are listed regardless of their parent folder.  # noqa: E501

        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'filename'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_files_all" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_files_count(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list files from. If not provided, counts files in the root folder.")] = None, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get Files Count  # noqa: E501

        Get file count in mediastorage, nesting is considered, if parent_folder_id is provided, counts only files in the root folder  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list files from. If not provided, counts files in the root folder.
        :type parent_folder_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_files_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_files_count_with_http_info(parent_folder_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_files_count_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list files from. If not provided, counts files in the root folder.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Files Count  # noqa: E501

        Get file count in mediastorage, nesting is considered, if parent_folder_id is provided, counts only files in the root folder  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list files from. If not provided, counts files in the root folder.
        :type parent_folder_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_files_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_folder(self, id_ : StrictInt, **kwargs) -> ResponseWrapperFolder:  # noqa: E501
        """Get Folder  # noqa: E501

        Get folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_folder_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_folder_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Folder  # noqa: E501

        Get folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_folders(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ResponseWrapperListFolder:  # noqa: E501
        """Get Folders  # noqa: E501

        List folders in mediastorage  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_folders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_folders_with_http_info(parent_folder_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_folders_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Folders  # noqa: E501

        List folders in mediastorage  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_folders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_folders_count(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get Folders Count  # noqa: E501

        Get folder count in mediastorage, nesting is considered, if parent_folder_id is provided, counts only subfolders of the root folder  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_folders_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_folders_count_with_http_info(parent_folder_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_folders_count_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Folders Count  # noqa: E501

        Get folder count in mediastorage, nesting is considered, if parent_folder_id is provided, counts only subfolders of the root folder  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_folders_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_file(self, id_ : StrictInt, file_update : FileUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update File  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param file_update: (required)
        :type file_update: FileUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_file_with_http_info(id_, file_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_file_with_http_info(self, id_ : StrictInt, file_update : FileUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update File  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param file_update: (required)
        :type file_update: FileUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_',
            'file_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['file_update'] is not None:
            _body_params = _params['file_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_folder(self, id_ : StrictInt, folder_update : FolderUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Folder  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param folder_update: (required)
        :type folder_update: FolderUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_folder_with_http_info(id_, folder_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_folder_with_http_info(self, id_ : StrictInt, folder_update : FolderUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Folder  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param folder_update: (required)
        :type folder_update: FolderUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_',
            'folder_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['folder_update'] is not None:
            _body_params = _params['folder_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_upload_file(self, file : Union[StrictBytes, StrictStr], parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, **kwargs) -> ResponseWrapperFileUploadResult:  # noqa: E501
        """Upload File  # noqa: E501

        Upload file to mediastorage  # noqa: E501

        :param file: (required)
        :type file: bytearray
        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFileUploadResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_upload_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_upload_file_with_http_info(file, parent_folder_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_upload_file_with_http_info(self, file : Union[StrictBytes, StrictStr], parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload File  # noqa: E501

        Upload file to mediastorage  # noqa: E501

        :param file: (required)
        :type file: bytearray
        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFileUploadResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'file',
            'parent_folder_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_upload_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file'] is not None:
            _files['file'] = _params['file']

        if _params['parent_folder_id'] is not None:
            _form_params.append(('parent_folder_id', _params['parent_folder_id']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFileUploadResult",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/upload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
