#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any

from .abstract import Token


@dataclass
class Attribute(Token):
    body: Token | None
    key: str

    def eval(self, key_to_binding: dict[str, Any]) -> Any:
        body = key_to_binding if self.body is None else self.body.eval(key_to_binding)
        if isinstance(body, dict):
            return body[self.key]
        else:
            return getattr(body, self.key)

    def get_root(self) -> Token:
        return self if self.body is None else self.body.get_root()
