#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass
from typing import Any


@dataclass
class Token(abc.ABC):
    @abc.abstractmethod
    def eval(self, key_to_binding: dict[str, Any]) -> Any:
        pass

    @abc.abstractmethod
    def get_root(self) -> 'Token':
        pass
