#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass, field
from typing import Any

from .abstract import Token


@dataclass
class Call(Token):
    body: Token
    args: list[Token] = field(default_factory=list)
    kwargs: dict[str, Token] = field(default_factory=dict)

    def eval(self, key_to_binding: dict[str, Any]) -> Any:
        callable_ = self.body.eval(key_to_binding)
        return callable_(
            *[val.eval(key_to_binding) for val in self.args],
            **{key: val.eval(key_to_binding) for key, val in self.kwargs.items()}
        )

    def get_root(self) -> Token:
        return self.body.get_root()