## ReferenceImageConnector

service to get, add and mark reference images

## Library Installation

```
pip install --extra-index-url https://pypi2.abm-jsc.ru reference-image-connector-abm
```

## Quick Start


#### Getting snapshot
```python
import asyncio

import aiohttp
from datetime import datetime
from reference_image_connector.connector import ReferenceImageConnector, EntityCondition


async def test_connector():
    
    session = aiohttp.ClientSession()
    
    reference_image_connector = ReferenceImageConnector(
        config=ReferenceImageConnector.Config(url="127.0.0.1:8080"),
        context=ReferenceImageConnector.Context(session=session)
    )
    
    reference_images = await reference_image_connector.get_reference_image_entities(
    filter_by=[EntityCondition(attribute="camera_id", value=None, operator="=")]
    )
    print(len(reference_images))
    rtsp_url = "rstp_url"
    file_ids = await reference_image_connector.get_reference_image_file_ids(
        stream_url=rtsp_url,
        date=datetime.fromisoformat("2023-05-11")
    )
    print(len(file_ids))
    
    await session.close()


asyncio.run(test_connector())
```
