#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import operator
from typing import ClassVar

from run_markdown.base_comparator import BaseComparator
from run_markdown.comparison_buffer import ComparisonBuffer
from run_markdown.comparison_line import TextComparisonLine
from run_markdown.utils import compare_string_with_pattern


class TextComparator(BaseComparator):
    chars_to_ignore: ClassVar[str] = '\r'
    def compare(self, value: str) -> ComparisonBuffer:
        expected = self.expected
        for char in self.chars_to_ignore:
            # expected = expected.replace(char, '')
            pass
        actual = value.replace('\r', '')
        result = ComparisonBuffer()
        for expected_line, actual_line in zip(expected.splitlines(), actual.splitlines()):
            if '...' in expected_line:
                comparator = compare_string_with_pattern
                error_text = 'Value mismatch'
            else:
                comparator = operator.eq
                error_text = 'Value non equal'
            exception = None if comparator(expected_line, actual_line) else ValueError(error_text)
            result.append(TextComparisonLine(expected_line, actual_line, exception))
        return result
