#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>

from detector_connector import DetectorHttpConnector

from shift_detector_connector.shift_settings import ShiftSettings


class ShiftDetectorHttpConnector(DetectorHttpConnector):
    Context = DetectorHttpConnector.Context
    Config = DetectorHttpConnector.Config

    def __init__(self, config: Config, context: Context):
        super().__init__(config=config, context=context, detector_settings_type=ShiftSettings)

    #backward compatibility
    async def correct_settings(self, stream_url: str, correct_file_id: str, token: str) -> bool:
        payload = {
                "correct_file_id": correct_file_id,
                "token": token,
                "stream_url": stream_url
        }
        answer = await self._connector.post_json("/settings/correct",
                                                 payload=payload,
                                                 headers=self._construct_headers())
        return answer["done"]
