#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#


def set_ids(*values):
    types = {type(val) for val in values}
    if len(types) != 1:
        raise ValueError(f'expected values of same type, got: {types}')
    type_ = types.pop()
    primary_key_constraint_columns = type_.__table__.primary_key.columns
    if len(primary_key_constraint_columns) != 1:
        raise ValueError(f'expected instances with exactly one primary key')

    primary_key_name = next(iter(primary_key_constraint_columns.keys()))
    for i, val in enumerate(values, 1):
        setattr(val, primary_key_name, i)
