#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>

from sqlalchemy import Index, Column


def create_index(*column_expressions: Column, unique: bool = False, **kwargs) -> Index:
    name = f'ix_{"_".join([col.name for col in column_expressions])}'
    return Index(name, *column_expressions, unique=unique, **kwargs)
