#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>


from dataclasses import dataclass

from detector_connector.detector_http_connector import DetectorHttpConnector, DetectorSettingsType
from detector_connector.detector_kafka_connector import DetectorKafkaConnector, DetectionAnalyzeResultType


class DetectorConnector:
    @dataclass
    class Config(DetectorHttpConnector.Config, DetectorKafkaConnector.Config):
        pass

    @dataclass
    class Context(DetectorHttpConnector.Context, DetectorKafkaConnector.Context):
        pass
    
    def __init__(self,
                 config: Config,
                 context: Context,
                 detector_analyze_result_type: DetectionAnalyzeResultType,
                 detector_settings_type: DetectorSettingsType) -> None:
        self.http_connector = DetectorHttpConnector(config=config,
                                                    context=context,
                                                    detector_settings_type=detector_settings_type)
        self.kafka_connector = DetectorKafkaConnector(config=config,
                                                      context=context,
                                                      detector_analyze_result_type=detector_analyze_result_type)
