#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
import json
from typing import Optional, Mapping, Any

from http_tools.http_server_connector import HttpServerConnector
from init_helpers.custom_json import Jsonable, custom_dumps
from multidict import MultiMapping


class HttpTechSupportConnector(HttpServerConnector):
    async def get_json(self, path: str, payload: Jsonable, path_params: MultiMapping = None,
                       headers: Optional[Mapping[str, str]] = None) -> Any:
        jsom_payload = custom_dumps(payload)
        payload = json.loads(jsom_payload)
        url = self._get_url(path)
        result = await self._requester.request(
            self._requester.Method.GET, url, params=path_params, json=payload, headers=headers)
        return result
