from dataclasses import dataclass
from enum import unique, StrEnum
from typing import List, Optional


@dataclass
class TicketListResponse:
    found: int
    tickets: List[dict]
    limit: int
    since: Optional[str]


@unique
class TicketType(StrEnum):
    RESOLUTION = 'resolution'
    MAINTENANCE = 'maintenance'
    REPAIR = 'repair'
