#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import datetime
import logging

from .timestamp import Timestamp, MILLISECONDS_PER_SECOND

logger = logging.getLogger(__name__)


class TimestampMs(Timestamp, int):
    def __new__(cls, value: int | float | datetime.datetime) -> 'TimestampMs':
        value = cls._prepare_value(value)
        if abs(value) < cls._MAX_TIMESTAMP_SEC:
            value *= MILLISECONDS_PER_SECOND

        while abs(value) > cls._MAX_TIMESTAMP_SEC * MILLISECONDS_PER_SECOND:
            value /= MILLISECONDS_PER_SECOND

        # noinspection PyArgumentList
        return int.__new__(cls, value)

    def total_seconds(self) -> float:
        return float(self / MILLISECONDS_PER_SECOND)
