#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass
from typing import Dict

from aiohttp import hdrs


class Auth:
    @dataclass
    class Config:
        api_token: str

    def __init__(self, config: Config):
        self._config = config

    @property
    def authorization_headers(self) -> Dict[str, str]:
        return {hdrs.AUTHORIZATION: f"Token {self._config.api_token}"}
