## Welcome to WeblateClient

Asynchronous Weblate client for asyncio and Python.

## Library Installation

```
pip install --extra-index-url https://pypi.abm-jsc.ru weblate-client-abm
```

## Quick Start


#### Get translations
```python
import asyncio
from typing import Any
from aiohttp import ClientSession

from weblate_client.weblate_client import WeblateClient

async def get_translations() -> Any:
    async with ClientSession() as session:
        weblate_client = WeblateClient(
            config=WeblateClient.Config(
                location="https://weblate.example/api",
                max_connections=5,
                api_token="token_example"
            ),
            context=WeblateClient.Context(
                session=session
            )
        )

        return await weblate_client.translation.get_translations_file_content(
            project="project_example", component="component_example", language="ru")


asyncio.run(get_translations())
```
