#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from abc import ABC
from dataclasses import dataclass

from http_tools.http_server_connector import HttpServerConnector

from ..auth import Auth


class AbstractApiEntity(ABC):
    @dataclass
    class Context:
        auth: Auth
        http_connector: HttpServerConnector

    def __init__(self, context: Context, base_path: str):
        self._context = context
        self._base_path = base_path
